/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sAdminPriv;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAdminPrivileges
extends Task {
    private String m_operation;
    private boolean m_toCheckNodeReach = true;
    private boolean m_toCheckUserEquiv;
    private String m_osdba = null;
    private String m_asmgrp = null;
    private String m_oraInv = null;
    private String m_oracleHome;
    private EnumSet<UserEquivCheckType> m_userEquivCheckTypeSet;
    static final String SRVM_PROPERTY_REMOTESHELL = "oracle.srvm.remoteshell";
    static final String SRVM_PROPERTY_REMOTECOPY = "oracle.srvm.remotecp";
    static final String ORACLE_SRVM_REMOTESHELL = "ORACLE_SRVM_REMOTESHELL";
    static final String ORACLE_SRVM_REMOTECOPY = "ORACLE_SRVM_REMOTECOPY";

    public TaskAdminPrivileges(String[] nodeList, String operation) {
        this(nodeList, operation, null, 1);
    }

    public TaskAdminPrivileges(String[] nodeList, String operation, MultiTaskHandler multiTaskHandler) {
        this(nodeList, operation, multiTaskHandler, 1);
    }

    public TaskAdminPrivileges(String[] nodeList, String operation, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_operation = operation;
        if (this.m_operation.equalsIgnoreCase("user_equiv")) {
            this.m_toCheckUserEquiv = true;
        }
    }

    public void setOperation(String operation) {
        this.m_operation = operation;
    }

    public void setOSDBA(String osdba) {
        this.m_osdba = osdba;
    }

    public void setASMADMIN(String asmgrp) {
        this.m_asmgrp = asmgrp;
    }

    public void setOraInv(String oraInv) {
        this.m_oraInv = oraInv;
    }

    public void setOracleHome(String oracleHome) {
        this.m_oracleHome = oracleHome;
    }

    public String getOSDBA() {
        return this.m_osdba;
    }

    public String getASMGRP() {
        return this.m_asmgrp;
    }

    public String getOraInv() {
        return this.m_oraInv;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setCheckUserEquiv(boolean toCheckUserEquiv) {
        this.m_toCheckUserEquiv = toCheckUserEquiv;
    }

    public void setCheckNodeReach(boolean toCheckNodeReach) {
        this.m_toCheckNodeReach = toCheckNodeReach;
    }

    @Override
    public boolean performTask() {
        String[] equivNodeArr;
        Trace.out((String)"Performing Admin Privileges verification task... ");
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        Vector unknownNodeVect = new Vector();
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String userName = System.getProperty("user.name");
        ResultSet userEquivResultSet = new ResultSet();
        if (this.m_toCheckUserEquiv) {
            String[] reachableNodeArr;
            if (this.m_toCheckNodeReach) {
                reachableNodeArr = VerificationUtil.getReachableNodes(this.m_nodeList, this.m_resultSet);
                if (reachableNodeArr == null) {
                    return false;
                }
            } else {
                reachableNodeArr = this.m_nodeList;
            }
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4004", false));
            Trace.out((String)"TaskAdminPrivileges:: Going to perform User Equivalence verification ...");
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4005", false, (Object[])new String[]{userName}));
            String oldRemoteShellProperty = null;
            boolean propertyChanged = false;
            boolean xwinCheckRequested = false;
            if (this.m_userEquivCheckTypeSet != null) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"TaskAdminPrivileges:: user equivalence check type specified");
                }
                boolean sshRequested = false;
                boolean rshRequested = false;
                for (UserEquivCheckType ctEnum : this.m_userEquivCheckTypeSet) {
                    if (ctEnum == UserEquivCheckType.CV_EQUIV_RSH) {
                        rshRequested = true;
                    }
                    if (ctEnum == UserEquivCheckType.CV_EQUIV_SSH) {
                        sshRequested = true;
                    }
                    if (ctEnum != UserEquivCheckType.CV_EQUIV_XWIN) continue;
                    xwinCheckRequested = true;
                }
                if (sshRequested && !rshRequested) {
                    String remoteSsh = this.getRemoteSsh(reachableNodeArr, this.m_resultSet);
                    if (remoteSsh == null) {
                        return false;
                    }
                    propertyChanged = true;
                    oldRemoteShellProperty = System.setProperty(SRVM_PROPERTY_REMOTESHELL, remoteSsh);
                    propertyChanged = !remoteSsh.equals(oldRemoteShellProperty);
                } else if (rshRequested && !sshRequested) {
                    String remoteRsh = this.getRemoteRsh(reachableNodeArr, this.m_resultSet);
                    if (remoteRsh == null) {
                        return false;
                    }
                    oldRemoteShellProperty = System.setProperty(SRVM_PROPERTY_REMOTESHELL, remoteRsh);
                    boolean bl = propertyChanged = !remoteRsh.equals(oldRemoteShellProperty);
                }
            }
            if (propertyChanged) {
                Trace.out((String)"Remote shell property changed. Resetting shell to be used");
                nativeSys.resetRemoteShellCmd();
            }
            boolean userEquivResult = new GlobalExecution().checkUserEquiv(reachableNodeArr, true, xwinCheckRequested, userEquivResultSet);
            if (propertyChanged) {
                if (oldRemoteShellProperty != null) {
                    System.setProperty(SRVM_PROPERTY_REMOTESHELL, oldRemoteShellProperty);
                } else {
                    System.clearProperty(SRVM_PROPERTY_REMOTESHELL);
                }
                Trace.out((String)"Remote shell property changed. Restore shell");
                nativeSys.resetRemoteShellCmd();
            }
            this.m_resultSet.uploadResultSet(userEquivResultSet);
            Trace.out((String)"TaskAdminPrivileges::   checkUserEquiv() performed!!");
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
            Hashtable t = userEquivResultSet.getResultTable();
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() == 1) {
                    ReportUtil.writeRecord(node, ReportUtil.PASSED);
                    succNodeVect.add(node);
                    continue;
                }
                failNodeVect.add(node);
                ReportUtil.writeRecord(node, ReportUtil.FAILED);
                Trace.out((String)("User Equivalence couldn't be performed on node: " + node));
            }
            if (userEquivResultSet.getStatus() == 1) {
                ReportUtil.printResult(s_msgBundle.getMessage("4006", false, (Object[])new String[]{userName}));
            } else {
                for (String node : userEquivResultSet.getFailureNodes()) {
                    Result result = userEquivResultSet.getResult(node);
                    String errInfo = result.getErrorInfoString();
                    String errMsg = s_gMsgBundle.getMessage("2019", true, (Object[])new String[]{userName, m_localHost, node});
                    if (VerificationUtil.isStringGood(errInfo)) {
                        errMsg = errMsg + LSEP + errInfo;
                    } else {
                        Trace.out((String)(node + ": NO INFORMATION AVAILABLE"));
                    }
                    ReportUtil.sureprintln(errMsg);
                    result.addErrorDescription(new ErrorDescription(errMsg));
                }
            }
            this.m_resultSet.uploadResultSet(userEquivResultSet);
            if (this.m_operation.equalsIgnoreCase("user_equiv")) {
                return userEquivResult;
            }
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4008", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            if (failNodeVect.size() != 0) {
                ReportUtil.printWarning(s_msgBundle.getMessage("4009", false));
                ReportUtil.sureprintNodelist(failNodeVect);
                ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
                ReportUtil.sureprintNodelist(succNodeVect);
            }
            equivNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
        } else {
            equivNodeArr = this.m_nodeList;
        }
        ResultSet destLocResultSet = new ResultSet();
        Vector<String> succDLNodes = new Vector<String>();
        Vector<String> failDLNodes = new Vector<String>();
        VerificationUtil.checkDestLoc(equivNodeArr, destLocResultSet, succDLNodes, failDLNodes, true);
        this.m_resultSet.uploadResultSet(destLocResultSet);
        if (succDLNodes.size() == 0) {
            return false;
        }
        String[] okNodeArr = succDLNodes.toArray(new String[succDLNodes.size()]);
        ResultSet admPrvResultSet = new ResultSet();
        boolean admPrvStatus = new sAdminPriv(okNodeArr, this.m_operation, admPrvResultSet, this).checkAdminPriv();
        this.m_resultSet.uploadResultSet(admPrvResultSet);
        return !this.m_resultSet.anyFailure();
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_operation.equalsIgnoreCase("user_equiv")) {
            return s_msgBundle.getMessage("4429", false);
        }
        return s_msgBundle.getMessage("4428", false);
    }

    @Override
    public String getTaskID() {
        if (this.m_operation.equalsIgnoreCase("user_equiv")) {
            return "USER_EQUIV";
        }
        return "ADMIN_PRIV";
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_operation.equalsIgnoreCase("user_equiv")) {
            return s_msgBundle.getMessage("4480", false);
        }
        return s_msgBundle.getMessage("4479", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    Operation: " + this.m_operation);
        sb.append("\n    UserEquivToBeChecked: " + this.m_toCheckUserEquiv);
        sb.append("\n    OSDBA: " + this.m_osdba);
        sb.append("\n    ORAINV: " + this.m_oraInv);
        return sb.toString();
    }

    public EnumSet<UserEquivCheckType> getUserEquivCheckTypeSet() {
        return this.m_userEquivCheckTypeSet;
    }

    public void setUserEquivCheckTypeSet(EnumSet<UserEquivCheckType> equivCheckTypeSet) {
        this.m_userEquivCheckTypeSet = equivCheckTypeSet;
    }

    private String getRemoteSsh(String[] nodeArr, ResultSet resultSet) {
        String val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTESHELL, true);
        String remoteShell = null;
        if (val != null && val.trim().length() != 0) {
            String fileName = this.verifyRemoteShellFile(nodeArr, resultSet, val);
            if (fileName == null) {
                return null;
            }
            if (fileName.equalsIgnoreCase("ssh")) {
                remoteShell = val;
            }
        }
        if (remoteShell == null) {
            remoteShell = this.verifyRemoteShellFile(nodeArr, resultSet, VDMUtil.getDefaultSsh());
        }
        return remoteShell;
    }

    private String getRemoteRsh(String[] nodeArr, ResultSet resultSet) {
        String val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTESHELL, true);
        String remoteShell = null;
        if (val != null && val.trim().length() != 0) {
            String fileName = this.verifyRemoteShellFile(nodeArr, resultSet, val);
            if (fileName == null) {
                return null;
            }
            if (fileName.equalsIgnoreCase("rsh")) {
                remoteShell = val;
            }
        }
        if (remoteShell == null) {
            remoteShell = this.verifyRemoteShellFile(nodeArr, resultSet, VDMUtil.getDefaultRsh());
        }
        return remoteShell;
    }

    private String verifyRemoteShellFile(String[] nodeArr, ResultSet resultSet, String absoluteFileName) {
        File userFile = new File(absoluteFileName);
        Object[] fileArg = new String[]{absoluteFileName};
        String fileName = userFile.getName();
        if (!fileName.equals("ssh") && !fileName.equals("rsh")) {
            String errorMsg = MessageBundle.getMessageBundle((String)"Prkc").getMessage("1042", false, fileArg);
            ReportUtil.println(errorMsg);
            resultSet.addResult(nodeArr, 2);
            resultSet.addErrorDescription(nodeArr, new ErrorDescription(errorMsg));
            ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
            return null;
        }
        if (!userFile.exists() || !userFile.isFile()) {
            String errorMsg = s_msgBundle.getMessage("0040", true, fileArg);
            ReportUtil.println(errorMsg);
            ErrorDescription errDesc = new ErrorDescription(errorMsg, s_msgBundle, "0040");
            resultSet.addResult(nodeArr, 2);
            resultSet.addErrorDescription(nodeArr, errDesc);
            ReportUtil.println(s_msgBundle.getMessage("0007", false));
            return null;
        }
        return absoluteFileName;
    }
}

